uniform sampler2D texture0;
uniform vec2 textureSize0;
uniform vec2 orientation;
uniform int changeColor;


const int stepCount = 9;

void main(void)
{   
    float gWeights[stepCount] ;
    gWeights[0] = 0.10855;
    gWeights[1] = 0.13135;
    gWeights[2] = 0.10406;
    gWeights[3] = 0.07216;
    gWeights[4] = 0.04380;
    gWeights[5] = 0.02328;
    gWeights[6] = 0.01083;
    gWeights[7] = 0.00441;
    gWeights[8] = 0.00157;

    float gOffsets[stepCount];
    gOffsets[0] = 0.66293;
    gOffsets[1] = 2.47904;
    gOffsets[2] = 4.46232;
    gOffsets[3] = 6.44568;
    gOffsets[4] = 8.42917;
    gOffsets[5] = 10.41281;
    gOffsets[6] = 12.39664;
    gOffsets[7] = 14.38070;
    gOffsets[8] = 16.36501;


	float pixelOffset;
    if (orientation.x == 1.0)
        pixelOffset = 1.0 / textureSize0.x;
    else
        pixelOffset = 1.0 / textureSize0.y;

	vec4 vTexCoord = gl_TexCoord[0];
	vec4 sum = vec4(0.0);
    
    for( int i = 0; i < stepCount; i++ )
    {                                                                                                                                                                
        float texCoordOffset = gOffsets[i] * pixelOffset; 
        
        vec4 aPixel = texture2D(texture0,vec2(vTexCoord.x+texCoordOffset*orientation.x,vTexCoord.y+texCoordOffset*orientation.y));
        vec4 bPixel = texture2D(texture0,vec2(vTexCoord.x-texCoordOffset*orientation.x,vTexCoord.y-texCoordOffset*orientation.y));

        sum += (aPixel + bPixel) * gWeights[i];
    }

    if (changeColor == 1)      
    {
        gl_FragColor = sum * gl_Color;  
        gl_FragColor.a = gl_FragColor.a / 2.0;  
    }
    else
    {
        gl_FragColor = sum;
    }
    
    gl_FragColor *= gl_Color;
}

